<?php
/*
=====================================================
 DleTrack (Module for CMS DataLife Engine)
-----------------------------------------------------
 Copyright (c) 2011 Alexander Ahminenko (PressFx)
=====================================================
     
-----------------------------------------------------
 E-Mail: a.ahminenko@gmail.com | ICQ: 68-12-16
=====================================================
*/
@session_start( );
@error_reporting( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set( 'display_errors', true );
@ini_set( 'html_errors', false );
@ini_set( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

define( 'DATALIFEENGINE', true );
define( 'ROOT_DIR', dirname( __FILE__ ) );
define( 'ENGINE_DIR', ROOT_DIR . '/engine' );

include_once ENGINE_DIR . '/data/config.php';
include_once ENGINE_DIR . '/classes/mysql.php';
include_once ENGINE_DIR . '/data/dbconfig.php';
include_once ENGINE_DIR . '/modules/functions.php';

$charset = 'cp1251';
$charsetalt = 'windows-1251';

$error = false;
$update = false;
$allow_delete = true;
$file_name = basename( __FILE__ );

if ( file_exists( ENGINE_DIR . '/data/dlemovie.php' ) ) {
	include_once ENGINE_DIR . '/data/dlemovie.php';
	if ( ! empty( $dlemovie_config['kiwi_allow'] ) ) $error = true;
	else {
		$update = true;
		$error = false;
	}
}
if ( ! $error ) {
	if ( ! $update ) {
	    $dbsql = $dlemovie_conf = array( );
		$dlemovie_conf['offline'] = 'no';
		$dlemovie_conf['mainname'] = '';
		$dlemovie_conf['offline_reason'] = '     .        .';
		$dlemovie_conf['hometype'] = 'video';
		$dlemovie_conf['video_topage'] = '15';
		$dlemovie_conf['video_toline'] = '3';
		$dlemovie_conf['category_topage'] = '15';
		$dlemovie_conf['category_toline'] = '3';
		$dlemovie_conf['video_title_max'] = '26';
		$dlemovie_conf['category_title_max'] = '26';
		$dlemovie_conf['date_format'] = 'j F Y, H:i';
		$dlemovie_conf['categories'] = 'yes';
		$dlemovie_conf['video_sort'] = '4';
		$dlemovie_conf['category_sort'] = '1';
		$dlemovie_conf['favorite_video'] = 'yes';
		$dlemovie_conf['rating_video'] = 'yes';
		$dlemovie_conf['comments'] = 'yes';
		$dlemovie_conf['video_code'] = 'yes';
		$dlemovie_conf['video_descr'] = 'yes';
		$dlemovie_conf['view_related'] = 'yes';
		$dlemovie_conf['view_related_max'] = '3';
		$dlemovie_conf['view_others'] = 'yes';
		$dlemovie_conf['view_others_max'] = '3';
		$dlemovie_conf['youtube_key'] = 'AI39si7LoSrtulq1eAU7L17w3Cm7I-VEKLlfwmBvRECW8XxgfpDKfgXMi5_rdbwgdnJxNG-2Mhkpja0puCzMc6GA4QucOjlifQ';
		$dlemovie_conf['youtube_email'] = 'name@gmail.com';
		$dlemovie_conf['youtube_passwd'] = '';
		$dlemovie_conf['youtube_player'] = 'jw-glow';
		$dlemovie_conf['update_last'] = time( );
		$dlemovie_conf['informer_userinfo'] = '<b>{count}</b> [{link}]';
		$dlemovie_conf['informer_favorite_limit'] = '6';
		$dlemovie_conf['informer_favorite_empres'] = 'string';
		$dlemovie_conf['youtube_allow'] = 'yes';
		$dlemovie_conf['rutube_allow'] = 'yes';
		$dlemovie_conf['vimeo_allow'] = 'yes';
		$dlemovie_conf['redtube_allow'] = 'no';
		$dlemovie_conf['vkontakte_allow'] = 'yes';
		$dlemovie_conf['kiwi_allow'] = 'yes';
		$dlemovie_conf['informers'] = 'yes';
		$dlemovie_conf['comments_sort'] = 'asc';
		$dlemovie_conf['comments_topage'] = '30';
		$dlemovie_conf['comments_minsize'] = '5';
		$dlemovie_conf['comments_maxsize'] = '3000';
		$dlemovie_conf['comments_concat'] = 'yes';

		$dbsql[] = "CREATE TABLE IF NOT EXISTS `" . PREFIX . "_dm_category` ( `id` int(8) NOT NULL auto_increment, `name` varchar(100) NOT NULL, `title` varchar(160) NOT NULL, `preview` varchar(200) NOT NULL, `descr` text NOT NULL, `videos` mediumint(10) NOT NULL default '0', `posi` mediumint(10) NOT NULL default '1', `previewup` smallint(1) NOT NULL default '1', UNIQUE KEY `id` (`id`), KEY `name` (`name`,`title`) ) ENGINE=MyISAM  DEFAULT CHARSET=" . $charset . " AUTO_INCREMENT=1;";
		$dbsql[] = "CREATE TABLE IF NOT EXISTS `" . PREFIX . "_dm_comments` ( `id` int(10) NOT NULL auto_increment, `video_id` mediumint(8) NOT NULL, `user_id` mediumint(8) NOT NULL, `user_name` varchar(40) NOT NULL, `date` varchar(20) NOT NULL, `email` varchar(80) NOT NULL, `text` text NOT NULL, `ip` varchar(16) NOT NULL, `is_register` smallint(1) NOT NULL default '0', UNIQUE KEY `id` (`id`) ) ENGINE=MyISAM  DEFAULT CHARSET=" . $charset . " AUTO_INCREMENT=1;";
		$dbsql[] = "CREATE TABLE IF NOT EXISTS `" . PREFIX . "_dm_ratings` ( `id` mediumint(8) NOT NULL auto_increment, `go_id` mediumint(8) NOT NULL, `type` varchar(10) NOT NULL, `member_id` mediumint(8) NOT NULL default '0', `member_ip` varchar(15) NOT NULL default '0', UNIQUE KEY `id` (`id`), KEY `go_id` (`go_id`,`type`,`member_id`,`member_ip`) ) ENGINE=MyISAM  DEFAULT CHARSET=" . $charset . " AUTO_INCREMENT=1;";
		$dbsql[] = "CREATE TABLE IF NOT EXISTS `" . PREFIX . "_dm_videos` ( `id` mediumint(10) NOT NULL auto_increment, `title` varchar(255) NOT NULL, `descr` text NOT NULL, `video` text NOT NULL, `provider` varchar(20) NOT NULL, `screen` varchar(200) NOT NULL, `playtime` mediumint(6) NOT NULL default '0', `category` mediumint(5) NOT NULL, `member` varchar(40) NOT NULL, `date` varchar(20) NOT NULL, `views` mediumint(5) NOT NULL default '0', `rating` mediumint(5) NOT NULL default '0', `comments` mediumint(5) NOT NULL default '0', `allowcomm` smallint(1) NOT NULL default '1', `approved` smallint(1) NOT NULL default '1', UNIQUE KEY `id` (`id`), FULLTEXT KEY `title` (`title`) ) ENGINE=MyISAM  DEFAULT CHARSET=" . $charset . " AUTO_INCREMENT=1;";
		$dbsql[] = "INSERT INTO `" . PREFIX . "_admin_sections` (`name`, `title`, `descr`, `icon`, `allow_groups`) VALUES
	('dlemovie', 'DleMovie&trade; ()', ' ,  ,  .', 'dlemovie.main.png', 'admin');";
		$dbsql[] = "ALTER TABLE `" . PREFIX . "_usergroups` ADD `dm_favorite_video` SMALLINT( 1 ) NOT NULL DEFAULT '1'";
		$dbsql[] = "ALTER TABLE `" . PREFIX . "_usergroups` ADD `dm_rating_video` SMALLINT( 1 ) NOT NULL DEFAULT '1'";
		$dbsql[] = "ALTER TABLE `" . PREFIX . "_usergroups` ADD `dm_upload_url` SMALLINT( 1 ) NOT NULL DEFAULT '1'";
		$dbsql[] = "ALTER TABLE `" . PREFIX . "_usergroups` ADD `dm_moderate` SMALLINT( 1 ) NOT NULL DEFAULT '0'";
		$dbsql[] = "ALTER TABLE `" . PREFIX . "_usergroups` ADD `dm_add_comment` SMALLINT( 1 ) NOT NULL DEFAULT '0'";
		$dbsql[] = "ALTER TABLE `" . PREFIX . "_users` ADD `dm_favorite_video` text NOT NULL";
		$dbsql[] = "ALTER TABLE `" . PREFIX . "_users` ADD `dm_comments` mediumint(6) NOT NULL default '0'";
		$dbsql[] = "UPDATE `" . PREFIX . "_usergroups` SET `dm_moderate` = '0' WHERE `id` <= 3";
		$dbsql[] = "UPDATE `" . PREFIX . "_usergroups` SET `dm_moderate` = '1' WHERE `id` >= 4";
		$dbsql[] = "UPDATE `" . PREFIX . "_usergroups` SET `dm_add_comment` = '1', `dm_upload_url` = '1' WHERE `id` != 5";
		$dbsql[] = "UPDATE `" . PREFIX . "_usergroups` SET `dm_favorite_video` = '0', `dm_upload_url` = '0' WHERE `id` = 5";

	    $configstr = "<" . "?php\n\$dlemovie_config = array(\n";
	    foreach ( $dlemovie_conf as $key => $value ) $configstr .= "    '" . $key . "' => '" . $value . "',\n";
	    foreach ( $dbsql as $sql ) $db->query( $sql );
	    $configstr .= ");\n?" . ">";
	    $fopen = @fopen( ENGINE_DIR . '/data/dlemovie.php', 'w+' );
	    @fwrite( $fopen, $configstr );
	    @fclose( $fopen );
		@chmod( ENGINE_DIR . '/data/dlemovie.php', 0666 );
	} else $db->query( "UPDATE `" . PREFIX . "_admin_sections` SET title = 'DleMovie&trade; ()', descr = ' ,  ,  .' WHERE name = 'dlemovie'" );
	@unlink( ENGINE_DIR . '/cache/system/usergroup.php' );
}
if ( ! $error and ! $update ) {
    $text1 = '     .';
    $text2 = '    ...';
    $text3 = '     (' . $file_name . ')    <br /> -   .';
} else if ( ! $error and $update ) {
    $text1 = '   .';
    $text2 = '    ...';
    $text3 = '     (' . $file_name . ').';
} else {
    $text1 = '     .';
    $text2 = '  .';
}
if ( ! $error and $allow_delete ) {
    if ( ! @unlink( $file_name ) ) $text2 = $text3;
} elseif ( ! $error ) $text2 = $text3;
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru" lang="ru">
    <head>
        <meta content="text/html; charset=<?=$charsetalt?>" http-equiv="Content-Type" />
        <style type="text/css">html,body{font-family:'Myriad Pro',Myriad, Arial,sans-serif;color:#666;background:#FFF}.wrapper{width:800px;margin:13% auto 0px auto}.title{font-size:60pt}.result{font-size:20pt}.descr{font-size:12pt}</style>
        <title>DleMovie&trade;</title>
    </head>
    <body>
        <div class="wrapper" align="center">
            <div class="title">DleMovie&trade; 1.2</div>
            <div class="result"><?php echo $text1 ?><br /><span class="descr"><?php echo $text2 ?></span></div>
        </div>
    </body>
</html>